import { jsx } from "react/jsx-runtime";
import { createContext, useContext, useState } from "react";
import { LicenseManager } from "./LicenseManager.mjs";
const LicenseContext = createContext({});
const useLicenseContext = () => useContext(LicenseContext);
function LicenseProvider({
  licenseKey,
  children
}) {
  const [licenseManager] = useState(() => new LicenseManager(licenseKey));
  return /* @__PURE__ */ jsx(LicenseContext.Provider, { value: licenseManager, children });
}
export {
  LicenseContext,
  LicenseProvider,
  useLicenseContext
};
//# sourceMappingURL=LicenseProvider.mjs.map
